<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Donationrequest extends Model 
{

    protected $table = 'donation_requests';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'phone', 'hospital_name', 'hospital_address', 'patient_age', 'blood_bags_count', 'details', 'latitude', 'longitude', 'blood_type_id', 'city_id', 'client_id');

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function bloodType()
    {
        return $this->belongsTo('App\Models\BloodType');
    }

    public function notification()
    {
        return $this->hasOne('App\Models\Notification');
    }

}